/*******************************************************
Filename		:  	DW_station_hub_custom.sql
Release 		:  	STORET c2.0, C2.0.1
SIR			:  	1370, 1560, 1557, 1560
Description		:  	Gatekeeper procedure that produces a shell HTML page
				and calls the procedure to generate a report or view a list
				of stations based on the user selection.
Author			:  	Joseph Wilson
Date			: 	November 11, 2002; December 5, 2002
                        	April 30, 2003 Pass '8' to footer routine to be used as a bookmark for the Help. - W Nash sir 1459  
                        	08/15/2003 - Removed 'BETA' from the page title. -CT
				10/29/2003 - Added report size feedback (SIR 1560) -JW
                        11/04/2003 - Added call to zip file. -CT
                        11/14/2003 - Removed zip file question; changed button label. -CT
Comments		:  	Displays a link to the report file created by the report generating
				procedure.  
**********************************************************/
SET DEF OFF;

CREATE OR REPLACE PROCEDURE DW_Station_Hub_Custom
(v_FromStmt		IN	VARCHAR2,
v_WhereStmt		IN 	VARCHAR2,
v_StationCount		IN 	VARCHAR2,
v_Columns 		owa_util.ident_arr,
report_type 		varchar2 :='CUSTOM'
)
AS

v_exists 		boolean;
v_file_length 		number;
v_blocksize 		number;

program_path  		varchar2(1000) := null;
script_path   		varchar2(1000) := null;
image_path    		varchar2(1000) := null;
page_title    		varchar2(100);
--
--The out_file variable will contain the entire URL of the file created within 
--the called download procedures.
--
out_file	  	varchar2(200);

BEGIN
	page_title :='Download Site Descriptions';
	DW_TOP_OF_PAGE(page_title, program_path, script_path, image_path);
      htp.print('<form action="DW_station_download_zip" method=POST>');

	htp.para;
	htp.para;
	htp.para;
	htp.print('<center>');
	IF report_type = 'CUSTOM' THEN
		htp.print('You have requested to download a custom site description');
		DW_station_download_custom(v_FromStmt,v_WhereStmt,v_Columns,'NONE',out_file);
	END IF;
	htp.Br;
	htp.Br;
	htp.Br;
	htp.anchor(out_file,htf.bold('Download your file now...'));
	utl_file.fgetattr(DW_GLOB_VAR.lv_iodir,out_file,v_exists,v_file_length,v_blocksize);
	htp.print('<br><br>The size of your report download is '||ROUND(v_file_length/1024,1)||'KB');
	htp.Br;
	htp.Br;
	htp.Br;
      htp.print('<input type="button" value="Compress Data File now" width=40 onClick="javascript:document.forms[1].submit();">');
	htp.print('</center>');
      htp.print('<input type="hidden" name="out_file" value='||out_file||'>');

	DW_bottom_of_page(8);
--END IF;
END;
/
show errors